#!/bin/sh

THISDIR=`pwd`
TARGET="i686-w64-mingw32"

CROSS_PATH="/opt/cross_win32"
PATH="$CROSS_PATH/bin:$PATH"
export PATH

. $THISDIR/prep_pthreads

cd pthreads

sed -e 's/dlltool$/& -m i386/' \
    -e 's/gcc$/& -m32/' \
    -e 's/g++$/& -m32/' \
    -e 's/windres$/& -F pe-i386/' \
    -e 's/pthreadGC\$(DLL_VER)/&-w32/g' \
    -e 's/pthreadGCE\$(DLL_VER)/&-w32/g' \
    < GNUmakefile.bak > GNUmakefile

make CROSS="$TARGET-" clean GC || exit 1

mkdir -p bin
mkdir -p $TARGET/include
mkdir -p $TARGET/lib
mkdir -p share/doc/pthreads-win32

cp -p pthread.h sched.h semaphore.h pthreads_win32_config.h ./$TARGET/include || exit 1
cp -p pthreadGC2-w32.dll ./bin || exit 1
cp -p libpthreadGC2-w32.a ./$TARGET/lib/libpthread.a || exit 1
for i in ANNOUNCE BUGS CONTRIBUTORS COPYING COPYING.LIB FAQ MAINTAINERS NEWS PROGRESS README README.CV README.NONPORTABLE README.WinCE TODO ;
  do cp -p ${i} ./share/doc/pthreads-win32 ;
done

$TARGET-strip ./bin/pthreadGC2-w32.dll

zip -9 -r -q pthreads-w32.zip bin $TARGET share || exit 1

cd ..

echo All DONE.

